﻿
namespace Framework.Web.UI
{
    /// <summary>
    /// 入力書式の列挙
    /// </summary>
    public enum InputFormat
    {
        /// <summary>
        /// 書式指定なし
        /// </summary>
        NotSet,

        /// <summary>
        /// 整数
        /// </summary>
        Int,

        /// <summary>
        /// 0より大きい整数
        /// </summary>
        PInt,

        /// <summary>
        /// 0以上の整数
        /// </summary>
        UInt,

        /// <summary>
        /// 実数
        /// </summary>
        Double,

        /// <summary>
        /// 0より大きい実数
        /// </summary>
        PDouble,

        /// <summary>
        /// 0以上の実数
        /// </summary>
        UDouble,

        /// <summary>
        /// decimal
        /// </summary>
        Decimal,
        /// <summary>
        /// 0より大きいdecimal
        /// </summary>
        PDecimal,

        /// <summary>
        /// 0以上のdecimal
        /// </summary>
        UDecimal,

        /// <summary>
        /// 日付
        /// </summary>
        Date,

        /// <summary>
        /// 正規表現
        /// </summary>
        Regex
    }

    public static class InputFormatExtension
    {
        public static bool IsInt(this InputFormat target)
        {
            return target == InputFormat.Int || target == InputFormat.UInt || target == InputFormat.PInt;
        }

        public static bool IsDouble(this InputFormat target)
        {
            return target == InputFormat.Double || target == InputFormat.UDouble || target == InputFormat.PDouble;
        }

        public static bool IsDecimal(this InputFormat target)
        {
            return target == InputFormat.Decimal || target == InputFormat.UDecimal || target == InputFormat.PDecimal;
        }

        public static bool IsDate(this InputFormat target)
        {
            return target == InputFormat.Date;
        }

        public static bool IsRegex(this InputFormat target)
        {
            return target == InputFormat.Regex;
        }
    }
}
